// PCIEDIODlg.cpp : implementation file
//

#include "stdafx.h"
#include "PCIEDIO.h"
#include "PCIEDIODlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPCIEDIODlg dialog

CPCIEDIODlg::CPCIEDIODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPCIEDIODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPCIEDIODlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPCIEDIODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPCIEDIODlg)
	DDX_Control(pDX, IDC_COMB_Board_ID, m_Board_ID);
	DDX_Control(pDX, IDC_ET_DIPSWID, m_DipSWID);
	DDX_Control(pDX, IDC_ET_P2_InputDada, m_ET_P2_Input);
	DDX_Control(pDX, IDC_ET_P1_InputDada, m_ET_P1_Input);
	DDX_Control(pDX, IDC_ET_P2_OutputDada, m_ET_P2_Output);
	DDX_Control(pDX, IDC_ET_P1_OutputDada, m_ET_P1_Output);
	DDX_Control(pDX, IDC_BT_P1_Write, m_BT_P1_Write);
	DDX_Control(pDX, IDC_BT_P2_Write, m_BT_P2_Write);
	DDX_Control(pDX, IDC_BT_P2_Read, m_BT_P2_Read);
	DDX_Control(pDX, IDC_BT_P1_Read, m_BT_P1_Read);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPCIEDIODlg, CDialog)
	//{{AFX_MSG_MAP(CPCIEDIODlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_RAD_P1_OutputMode, OnRADP1OutputMode)
	ON_BN_CLICKED(IDC_RAD_P1_InputMode, OnRADP1InputMode)
	ON_BN_CLICKED(IDC_RAD_P2_OutputMode, OnRADP2OutputMode)
	ON_BN_CLICKED(IDC_RAD_P2_InputMode, OnRADP2InputMode)
	ON_BN_CLICKED(IDC_RAD_1PA, OnRad1pa)
	ON_BN_CLICKED(IDC_RAD_1PB, OnRad1pb)
	ON_BN_CLICKED(IDC_RAD_1PC, OnRad1pc)
	ON_BN_CLICKED(IDC_RAD_2PA, OnRad2pa)
	ON_BN_CLICKED(IDC_RAD_2PB, OnRad2pb)
	ON_BN_CLICKED(IDC_RAD_2PC, OnRad2pc)
	ON_BN_CLICKED(IDC_BT_P1_Write, OnBTP1Write)
	ON_BN_CLICKED(IDC_BT_P1_Read, OnBTP1Read)
	ON_BN_CLICKED(IDC_BT_P2_Write, OnBTP2Write)
	ON_BN_CLICKED(IDC_BT_P2_Read, OnBTP2Read)
	ON_BN_CLICKED(IDC_BT_Select_Board, OnBTSelectBoard)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPCIEDIODlg message handlers

BOOL CPCIEDIODlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CButton* pbt;
	pbt = (CButton*)GetDlgItem(IDC_RAD_P1_OutputMode);
	pbt->SetCheck(1);
	pbt = (CButton*)GetDlgItem(IDC_RAD_P2_InputMode);
	pbt->SetCheck(1);
	pbt = (CButton*)GetDlgItem(IDC_RAD_1PA);
	pbt->SetCheck(1);
	pbt = (CButton*)GetDlgItem(IDC_RAD_2PA);
	pbt->SetCheck(1);
	isopen = 0;
	p1_ofset = 0x0;
	p2_ofset = 0x03;
	boardid = 0;
	m_ET_P1_Output.SetWindowText("55");
	open();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPCIEDIODlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPCIEDIODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPCIEDIODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPCIEDIODlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	PciTg2_close2();	
}

void CPCIEDIODlg::OnRADP1OutputMode() 
{
	int status = 0;
	int rdata = 0;
	if(!isopen) return;

    //[IO] control offset: 0x06
	//Read IO control register data
	rdata = PciTg2_in2(boardid, 0x6);
	rdata &=0x70;

	//Set 1PA/B/C to output mode
	status = PciTg2_out2(boardid, 0x6, rdata);	
    
	m_BT_P1_Read.EnableWindow(0);
	m_BT_P1_Write.EnableWindow(1);	
}

void CPCIEDIODlg::OnRADP1InputMode() 
{
	int status = 0;
	int rdata = 0;
	if(!isopen) return;
    
	//[IO] control offset: 0x06
    //Read IO control register data
	rdata = PciTg2_in2(boardid, 0x6);
	rdata |=0x07;
    
	//Set 1PA/B/C to input mode
	status = PciTg2_out2(boardid, 0x6, rdata);

	m_BT_P1_Read.EnableWindow(1);
	m_BT_P1_Write.EnableWindow(0);	
}

void CPCIEDIODlg::OnRADP2OutputMode() 
{
	int status = 0;
	int rdata = 0;
	if(!isopen) return;

	//[IO] control offset: 0x06
	//Read IO control register data
	rdata = PciTg2_in2(boardid, 0x6);
	rdata &=0x07;
	
	//Set 2PA/B/C to output mode
	status = PciTg2_out2(boardid, 0x6, rdata);

	m_BT_P2_Write.EnableWindow(1);
	m_BT_P2_Read.EnableWindow(0);	
}

void CPCIEDIODlg::OnRADP2InputMode() 
{
	int status = 0;
	int rdata = 0;
	if(!isopen) return;
	
	//[IO] control offset: 0x06
	//Read IO control register data
	rdata = PciTg2_in2(boardid, 0x6);
	rdata |=0x70;

	//Set 2PA/B/C to input mode
	status = PciTg2_out2(boardid, 0x6, rdata);
	
	m_BT_P2_Write.EnableWindow(0);
	m_BT_P2_Read.EnableWindow(1);	
}

void CPCIEDIODlg::OnRad1pa() 
{
    //[1PA] control offset: 0x0
    p1_ofset = 0x0;		
}

void CPCIEDIODlg::OnRad1pb() 
{
    //[1PB] control offset: 0x01
	p1_ofset = 0x01;	
}

void CPCIEDIODlg::OnRad1pc() 
{
	//[1PC] control offset: 0x02
	p1_ofset = 0x02;	
}

void CPCIEDIODlg::OnRad2pa() 
{
	//[2PA] control offset: 0x03
	p2_ofset = 0x03;
	
}

void CPCIEDIODlg::OnRad2pb() 
{
	//[2PB] control offset: 0x04
	p2_ofset = 0x04;	
}

void CPCIEDIODlg::OnRad2pc() 
{
	//[2PC] control offset: 0x05
	p2_ofset = 0x05;	
}

void CPCIEDIODlg::OnBTP1Write() 
{
	CString strtmp;
	int status = 0;
	unsigned long wdata=0x0;

	if(!isopen) return;
	m_ET_P1_Output.GetWindowText(strtmp);
	wdata= strtoul( strtmp, NULL, 16 );
	wdata &=0xFF;

	status = PciTg2_out2(boardid, p1_ofset, wdata);
}

void CPCIEDIODlg::OnBTP1Read() 
{
	CString strtmp;
	unsigned long rdata=0x0;

	if(!isopen) return;
	rdata = PciTg2_in2(boardid, p1_ofset);

	strtmp.Format("%X",rdata);
	m_ET_P1_Input.SetWindowText(strtmp);
}

void CPCIEDIODlg::OnBTP2Write() 
{
	CString strtmp;
	int status = 0;
	unsigned long wdata=0x0;

	if(!isopen) return;	
	m_ET_P2_Output.GetWindowText(strtmp);
	wdata= strtoul( strtmp, NULL, 16 );
	wdata &=0xFF;
    
	status = PciTg2_out2(boardid, p2_ofset, wdata);
}

void CPCIEDIODlg::OnBTP2Read() 
{	
	CString strtmp;
    unsigned long rdata=0x0;
	if(!isopen) return;

	rdata = PciTg2_in2(boardid, p2_ofset);
	strtmp.Format("%X",rdata);
    m_ET_P2_Input.SetWindowText(strtmp);
}
void CPCIEDIODlg::OnBTSelectBoard() 
{
	int rdata = 0;
    int dipswid = 0;
	CString strtmp;
	
	if(!isopen) return;
	m_Board_ID.GetWindowText(strtmp);
	if(!strtmp.IsEmpty()) 
	{
		boardid = atoi(strtmp);	
		rdata = PciTg2_in2(boardid,0x6);  
		//Get DIP switch ID1 value
		if(rdata & 0x80)
			dipswid |=0x02;

		//Get DIP switch ID2 value
		if(rdata & 0x08)
			dipswid |=0x01;
    
		strtmp.Format("%d",dipswid);
		m_DipSWID.SetWindowText(strtmp);
	}
}
int CPCIEDIODlg::open() 
{
	int status = 0;
	int rdata = 0;
    int dipswid = 0;
	CString strtmp;
	int validswid[4];

	status = PciTg2_open2();
	if (status != 0)
	{
		MessageBox(_T("No PCIE DIO card found on system ! "), 
			_T("Confirm Card Exist"), MB_OK | MB_ICONSTOP);
		return 1;
	}
    isopen = true;

	PciTg2_getvalidid2(validswid);
	for(int i=0; i< 4;i++)
	{
	   if (validswid[i] == 1)
	   {
		   boardid = i;
		   strtmp.Format("%d", boardid);
		   m_Board_ID.AddString(strtmp);
	   }
	}
	m_Board_ID.SetCurSel(m_Board_ID.GetCount()-1);

	rdata = PciTg2_in2(boardid,0x6);
    
	//Get DIP switch ID1 value
	if(rdata & 0x80)
        dipswid |=0x02;

	//Get DIP switch ID2 value
	if(rdata & 0x08)
		dipswid |=0x01;
    
    strtmp.Format("%d",dipswid);
    m_DipSWID.SetWindowText(strtmp);


    //Set 1PA/B/C  to output mode, 2PA/B/C to input mode
	status = PciTg2_out2(boardid, 0x6, 0x70);

	OnRADP1OutputMode();
	OnRADP2InputMode();
    return 0;	
}
